/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.armor;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class StickyModifier
extends IncrementalModifier {
    private static MobEffectInstance getEffect(float scaledLevel) {
        int duration = 20;
        int maxBonus = (int)(10.0f * scaledLevel);
        if (maxBonus > 0) {
            duration += RANDOM.nextInt(maxBonus);
        }
        return new MobEffectInstance(MobEffects.f_19597_, duration, Math.round(scaledLevel));
    }

    @Override
    public void onAttacked(IToolStackView tool, int level, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        Entity attacker = source.m_7639_();
        if (isDirectDamage && attacker instanceof LivingEntity) {
            float scaledLevel = this.getScaledLevel(tool, level);
            if (RANDOM.nextFloat() < scaledLevel * 0.25f) {
                ((LivingEntity)attacker).m_7292_(StickyModifier.getEffect(scaledLevel));
                ToolDamageUtil.damageAnimated(tool, 1, context.getEntity(), slotType);
            }
        }
    }

    @Override
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        LivingEntity target = context.getLivingTarget();
        if (target != null) {
            target.m_7292_(StickyModifier.getEffect(this.getScaledLevel(tool, level)));
        }
        return 0;
    }
}

